<?LassoScript
// Prepared for Lasso Summit 2006
// by Eric Landmann, Landmann InterActive, elandmann@landmanninteractive.com

// VERSION NOTES
// This has been tested with ImageMagick versions 6.1.5 and 6.2.0, and PassThru 2.5.8 on Lasso 8.0 and 8.1

// Debugging
// To turn debugging on, set the variable svDebug = Y
Var:'svDebug' = 'N';

// Domain name
Var:'svDomain' = '127.0.0.1';	

// Databases & User Authentication
Var:'svDatabase' = 'beta_content_demo',
	'svUsername' = 'beta_CMS',
	'svPassword' = '9andromeda7';

// Table Names
Var:'svContentTable' = 'beta_content',
	'svCategoryTable' = 'beta_crag',
	'svImagesTable' = 'beta_images';

// Define Errors Database and Table
Var:'svErrorsDB'='beta_content_demo',
	'svErrorsTable'='beta_errors';

// PassThru Username and Password
Var:'svPassThruUsername' = 'LassoAdmin',
	'svPassThruPassword' = '8gatewayZ';

// UploadUsername and password for file permissions
Var:'svFileUsername' = 'LassoAdmin',
	'svFilePassword' = '8gatewayZ';

// Used to determine if we want to archive the original upload file
// If so, files are renamed and moved to /upload_processed/
Var:'svArchiveOriginalUpload' = True;

// Path to ImageMagick, we are using the version in the Lasso folder
// You can use a stand-alone version by changing this path
// Double quotes are necessary due to spaces in filepath
Var:'svPathToIM' = '"/Applications/Lasso Professional 8/ImageMagick-6.2.0/bin/"';

// Path to the webserver root
Var:'svWebserverRoot' = '/Library/Webserver/Documents';

// Code Libraries Path
Var:'svLibsPath'='/site/libs/';

// Masthead Path
Var:'svMastheadPath'='/site/masthead/';

// Upload directories
// This is the upload folder path from web root
Var:'svULpathImageLarge' = '/site/images/large/',
	'svULpathImageMed' = '/site/images/med/',
	'svULpathImageThumb' = '/site/images/thumb/';

// Design and Content Variables
Var:'svInputHeaderColor'='#330000',
	'svInputContentColor'='#CCCCCC';

// Define today's date
Var:'svDateCreated' = (Date_Format: (Date_GetCurrentDate), -DateFormat='%Y-%m-%d');

// CUSTOM TAGS
// Pier Kuipers` Create Unique ID custom tag
If: !(Lasso_TagExists: 'Create_UID');
	Define_Tag: 'Create_UID';
		Local: 'UID_Characters' = 'AaBb9CcDd8EeFf7GgHh6iJj5KkLm4NnoPp3QqRr2SsTt1UuVv9WwXx8YyZz';
		Local: 'UID_StringLength' = 12;
		Local: 'newUID' = (String);
		Loop: #UID_StringLength;
			Local: 'a_Character' = #UID_Characters->(Get:(Math_Random: -Min=1, -Max=(#UID_Characters->Size)));
			#newUID += #a_Character;
		/Loop;
		Return: #newUID;
	/Define_Tag;
/If;

// Variation of Pier`s Create Unique ID custom tag
// Used by Upload system to append a unique ID of only 3 digits
If: !(Lasso_TagExists: 'Create_UIDShort');
	Define_Tag: 'Create_UIDShort';
		Local: 'UID_Characters' = 'AaBb9CcDd8EeFf7GgHh6iJj5KkLm4NnoPp3QqRr2SsTt1UuVv9WwXx8YyZz';
		Local: 'UID_StringLength' = 3;
		Local: 'newUID' = (String);
		Loop: #UID_StringLength;
			Local: 'a_Character' = #UID_Characters->(Get:(Math_Random: -Min=1, -Max=(#UID_Characters->Size)));
			#newUID += #a_Character;
		/Loop;
		Return: #newUID;
	/Define_Tag;
/If;

//	Show Error CT
//  Version 2.0
//  1/6/2005 by ECL, Landmann InterActive
//  New version that includes all HTML code and a parameter to accept a background color
//  Usage: Show_Error: -ErrNum=1001, -Color='FF0066', -Option=Something
		
If: !(Lasso_TagExists:'Show_Error');
	Define_Tag: 'Show_Error',
		-Required = 'ErrNum',
		-Required = 'PosColor',
		-Required = 'NegColor',
		-Required = 'BgColor',
		-Optional = 'Option';

		Local:'Result' = '';

		If: #ErrNum != '';
			Inline: -Database=$svErrorsDB,-Table=$svErrorsTable,-UserName=$svUsername,-Password=$svPassword,
				-SQL="SELECT Code, Message, Title, Attrib
					FROM "+$svErrorsDB "." $svErrorsTable "
					WHERE Code= '" (#ErrNum) "';";
						Var:'vErr' = (Error_CurrentError) ' -- ' (Error_CurrentError: -ErrorCode);
						Var:'vErrNo' = (Error_CurrentError: -ErrorCode);
	
					If: $vErrNo == 0;
						If: (Found_Count)== 0;
							#Result += 'No Error Message Found';
						Else;

							// Get Attribute from database and assign coloor
							If: (Field:'Attrib') == 'Pos';
								Local:'HeaderColor' = (#PosColor);
							Else;
								Local:'HeaderColor' = (#NegColor);
							/If;

							// Output top of table
							#Result =
								'<table width="80%" border="0" cellspacing="1" cellpadding="2">\r'
								'\t<tr>\r'
								'\t\t<td bgcolor="#' (#HeaderColor)'"><b><font color="#FFFFFF">';
							
							If: #Option != '';
								#Result += ((Field:'Title')'</font></b><br>\r\t\t</td>\r\t</tr>\r\t<tr>\r\t\t<td bgcolor="#'(#BgColor)'">'(String_Replace: (Field:'Message'), -Find='<form_input>', -Replace=(#Option)));
							Else;
								#Result += ((Field:'Title')'</font></b><br>\r\t\t</td>\r\t</tr>\r\t<tr>\r\t\t<td bgcolor="'(#BgColor)'"><font color="#000000">'(Field:'Message'));
							/If;
						/If;
					Else;
						#Result += $vErr;
					/If;
			/inline;
		Else;
			// Output top of table
			#Result =
				'<table width="80%" border="0" cellspacing="1" cellpadding="2">\r'
				'\t<tr>\r'
				'\t\t<td bgcolor="#'(#HeaderColor)'"><b><font color="'(#BgColor)'">';
					#Result += 'EXCEPTION: An Unknown Error Was Generated';
		/If;

	// Output bottom of table
	#Result +=
		'</font></td>\r'
		'\t</tr>\r'
		'</table>\r'
		'&nbsp;<br>\r';

			Return: Encode_Smart:(#Result);

	 /Define_Tag; 

/If;

?>